<?php
class Database {

    private $serverName = "DESKTOP-LIMKFU4";
    private $connectionOptions = [
        "Database" => "admin_system",
        "Uid" => "sa",
        "PWD" => "Password10$"
        // "TrustServerCertificate" => true,
        // "Encrypt" => false,
        // "CharacterSet" => "UTF-8"
    ];
    public $conn;
    
    public function __construct() {
        $this->connect();
    }
    
    private function connect() {
        $this->conn = null;
        
        try {
            $this->conn = sqlsrv_connect($this->serverName, $this->connectionOptions);
            
            if ($this->conn === false) {
                $errors = sqlsrv_errors();
                error_log("SQL Server connection error: " . print_r($errors, true));
                throw new Exception("Database connection failed".json_encode(print_r($errors, true)));
            }
        } catch (Exception $e) {
            error_log("Database connection error: " . $e->getMessage());
            die("Database connection failed ". $e->getMessage());
        }
    }
    
    public function prepare($sql, $params = []) {
        return sqlsrv_prepare($this->conn, $sql, $params);
    }
    
    public function execute($stmt) {
        return sqlsrv_execute($stmt);
    }
    
    public function fetchArray($stmt) {
        return sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC);
    }
    
    public function getLastInsertId() {
        $stmt = sqlsrv_query($this->conn, "SELECT SCOPE_IDENTITY() AS id");
        if ($stmt && sqlsrv_fetch($stmt)) {
            return sqlsrv_get_field($stmt, 0);
        }
        return null;
    }
}
?>